/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package ex1;

/**
 *
 * @author ttt
 */
public class Rectangle {

    private Point upLeftVertex;
    private Point downRightVertex;

    
    // common constructor
    public Rectangle(Point x, Point y) {
        setUpLeftVertex(x);
        setDownRightVertex(y);
    }

    // default constructor
    public Rectangle() {
        this(new Point(), new Point());
    }

    // copy constructor
    public Rectangle(Rectangle rectangle) {
        this(rectangle.getUpLeftVertex(), rectangle.getDownRightVertex());
    }

    public double Diagonal() {
        int width = getUpLeftVertex().getX() - getDownRightVertex().getX();
        int height = getUpLeftVertex().getY() - getDownRightVertex().getY();
        return Math.sqrt(width*width + height*height);
    }
    
    @Override
    public String toString() {
        return String.format("{%s, %s}", getUpLeftVertex(), getDownRightVertex());
    }
    
    /**
     * @return the upLeftVertex
     */
    public Point getUpLeftVertex() {
        return upLeftVertex;
    }

    /**
     * @param upLeftVertex the upLeftVertex to set
     */
    public void setUpLeftVertex(Point upLeftVertex) {
        this.upLeftVertex = upLeftVertex;
    }

    /**
     * @return the downRightVertex
     */
    public Point getDownRightVertex() {
        return downRightVertex;
    }

    /**
     * @param downRightVertex the downRightVertex to set
     */
    public void setDownRightVertex(Point downRightVertex) {
        this.downRightVertex = downRightVertex;
    }

}
