// Fig. 8.11: EnumTest.java
// Testing enum type Book.
import java.util.EnumSet;
  
public class EnumTest 
{    
   enum A {OK, NO}; // simple use of enum
   private static int[] i = new int[3];
   static
   {
       for (int k = 0; k<i.length; k++)
           i[k] = k;
   }
   public static void main( String args[] ) 
   {
      
      
      System.out.println( "All books:\n" );
      Book t = Book.JHTP6;  // enum assignment
      A tt = A.NO;          // enum assignment
      switch(tt) // using enum in switch
      {
          case NO:
                   System.out.printf( "%-10s%-45s%s\n\n", t,
             t.getTitle(), t.getCopyrightYear() );
      }
 
      
      // Convert enum.values() to an array
      Book b[] =  Book.values() ;
      System.out.printf( "%-10s%-45s%s\n\n", b[0],
             b[0].getTitle(), b[0].getCopyrightYear() );
      
      // print all books in enum Book                          
      for ( Book book : Book.values() )                        
         System.out.printf( "%-10s%-45s%s\n", book,
             book.getTitle(), book.getCopyrightYear() );

      System.out.println( "\nDisplay a range of enum constants:\n" );
      // Convert EnumSet.range() to an array
      Object bu[] =  (EnumSet.range( Book.JHTP6, Book.CPPHTP4 ).toArray()) ;
      Book bb[] = new Book[bu.length];
      for (int i = 0; i< bu.length; i++)
          bb[i] = (Book) bu[i];
      
      System.out.printf( "%-10s%-45s%s\n\n", bb[0],
             bb[0].getTitle(), bb[0].getCopyrightYear() );
      
      // print first four books                                 
      for ( Book book : EnumSet.range( Book.JHTP6, Book.CPPHTP4 ) )
         System.out.printf( "%-10s%-45s%s\n", book,
             book.getTitle(), book.getCopyrightYear() );
   } // end main
} // end class EnumTest

