// Fig. 8.7: Date.java 
// Date class declaration.

public class Date 
{
   private int month; // 1-12
   private int day;   // 1-31 based on month
   private int year;  // any year

   // constructor: call checkMonth to confirm proper value for month; 
   // call checkDay to confirm proper value for day
   public Date( int theMonth, int theDay, int theYear )
   {
      setMonth( theMonth ); // validate month
      year = theYear; // could validate year
      setDay( theDay ); // validate day

      System.out.printf( 
         "Date object constructor for date %s\n", this );
   } // end Date constructor
  
   // copy constructor
   public Date( Date d )
   {
   	this(d.month, d.day, d.year);
   }
     
   // default  constructor
   public Date( )
   {
   	this(1, 1, 2000);
   }
   // set month method 
   public void setMonth( int testMonth)
   {
   	if ( testMonth > 0 && testMonth <= 12 )
   	   month  =  testMonth ;
   	else
   	    month =  1 ;
   } // end set month method 
   
   // set day 
   public void setDay( int testDay )
   {
     int daysPerMonth[] = 
         { 0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 };
         
      day = 1; // by default
      // check if day in range for month
      if ( testDay > 0 && testDay <= daysPerMonth[ month ] )
         day =  testDay;
   
      // check for leap year
      if ( month == 2 && testDay == 29 && ( year % 400 == 0 || 
           ( year % 4 == 0 && year % 100 != 0 ) ) )
         day =  testDay;
      
   } // end set Day method    
 

   
   // return a String of the form month/day/year
   public String toString()
   { 
      return String.format( "%d/%d/%d", month, day, year ); 
   } // end method toString
} // end class Date

