// Fig. 8.8: Employee.java
// Employee class with references to other objects.

public class Employee 
{
   private String firstName;
   private String lastName;
   private Date birthDate;
   private Date hireDate;

   // constructor to initialize name, birth date and hire date
   public Employee( String first, String last, Date dateOfBirth, 
      Date dateOfHire )
   {
      firstName = first;
      lastName = last;
      // memory sharing is not desirable here!!!
      birthDate = dateOfBirth;  // a copy constructor is required
      hireDate  = dateOfHire;    // a copy constructor is required
   } // end Employee constructor
   public Date getBirthDate()
   {
   	return birthDate;
   }
   public Date getHireDate()
   {
   	return hireDate;	
   }
   // convert Employee to String format
   public String toString()
   {
      return String.format( "%s, %s  Hired: %s  Birthday: %s", 
         lastName, firstName, hireDate, birthDate );
   } // end method toEmployeeString
} // end class Employee

