/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package ex1;

/**
 *
 * @author ttt
 */
public final class MathArray {

    private int table[][];

    private int row[];

    public MathArray() {
        int initTable[][] = new int[][]{
            {3, 2, 3, 1, 9},
            {4, 1, 2, 0, 2},
            {5, 2, 1, 0, 6},
            {6, 1, 4, 1, 4},
            {3, 1, 9, 1, 9}
        };
        setTable(initTable);

        int initRow[] = new int[]{2, 1, 2, 3, 4};
        setRow(initRow);
    }

    public int[] multiplyMatrixByRow() {
        int[] multiplyMatrixByRow = new int[5];
        for (int i = 0; i < getTable().length; i++) {
            int tableColumn[] = getTable()[i];
            for (int j = 0; j < tableColumn.length; j++) {
                multiplyMatrixByRow[j] += tableColumn[j] * getRow()[j];
            }
        }
        return multiplyMatrixByRow;
    }

    public int[][] squareMatrix() {
        int[][] squareMatrix = new int[5][5];
        for (int i = 0; i < getTable().length; i++) {
            for (int j = 0; j < getTable().length; j++) {
                squareMatrix[i][j] = getTable()[i][j] * getTable()[j][i];
            }
        }
        return squareMatrix;
    }

    public int scalarProduct() {
        int scalarProduct = 0;
        for (int i = 0; i < getRow().length; i++) {
            scalarProduct += getRow()[i] * getRow()[i];
        }
        return Math.abs(scalarProduct);
    }

    public int[][] transposeMatrix() {
        int[][] transposeMatrix = new int[5][5];
        for (int i = 0; i < getTable().length; i++) {
            for (int j = 0; j < getTable().length; j++) {
                transposeMatrix[i][j] = getTable()[j][i];
            }
        }
        return transposeMatrix;
    }

    public int matrixTrace() {
        int matrixTrace = 0;
        for (int i = 0; i < getTable().length; i++) {
            for (int j = 0; j < getTable().length; j++) {
                if (i == j) {
                    matrixTrace += getTable()[i][j];
                }
            }
        }
        return matrixTrace;
    }

    public String toString(int[] matrix) {
        String result = "";
        result += String.format("%nrow%n");
        for (int i = 0; i < matrix.length; i++) {
            if (i != (matrix.length - 1)) {
                result += matrix[i] + ", ";
            } else {
                result += matrix[i];
            }
        }
        return result;
    }

    public String toString(int[][] matrix) {
        String result = "";
        result += String.format("%ntable%n");
        for (int i = 0; i < matrix.length; i++) {
            for (int j = 0; j < matrix.length; j++) {
                if (j != (matrix.length - 1)) {
                    result += matrix[i][j] + ", ";
                } else {
                    result += matrix[i][j];
                }
                if (j == (matrix.length - 1)) {
                    result += String.format("%n");
                }
            }
        }
        return result;
    }

    public String toString() {
        String result = "";
        result += String.format("table%n");
        for (int i = 0; i < getTable().length; i++) {
            for (int j = 0; j < getTable().length; j++) {
                if (j != (getTable().length - 1)) {
                    result += getTable()[i][j] + ", ";
                } else {
                    result += getTable()[i][j];
                }
                if (j == (getTable().length - 1)) {
                    result += String.format("%n");
                }
            }
        }
        result += String.format("%nrow%n");
        for (int i = 0; i < getRow().length; i++) {
            if (i != (getRow().length - 1)) {
                result += getRow()[i] + ", ";
            } else {
                result += getRow()[i];
            }
        }
        return result;
    }

    /**
     * @return the table
     */
    public int[][] getTable() {
        return table;
    }

    /**
     * @param table the table to set
     */
    public final void setTable(int[][] table) {
        this.table = table;
    }

    /**
     * @return the row
     */
    public int[] getRow() {
        return row;
    }

    /**
     * @param row the row to set
     */
    public void setRow(int[] row) {
        this.row = row;
    }
}
