/*
 * Decompiled with CFR 0.152.
 */
package ex1;

public final class MathArray {
    private int[][] table;
    private int[] row;

    public MathArray() {
        int[][] initTable = new int[][]{{3, 2, 3, 1, 9}, {4, 1, 2, 0, 2}, {5, 2, 1, 0, 6}, {6, 1, 4, 1, 4}, {3, 1, 9, 1, 9}};
        this.setTable(initTable);
        int[] initRow = new int[]{2, 1, 2, 3, 4};
        this.setRow(initRow);
    }

    public int[] multiplyMatrixByRow() {
        int[] multiplyMatrixByRow = new int[5];
        for (int i = 0; i < this.getTable().length; ++i) {
            int[] tableColumn = this.getTable()[i];
            for (int j = 0; j < tableColumn.length; ++j) {
                int n = j;
                multiplyMatrixByRow[n] = multiplyMatrixByRow[n] + tableColumn[j] * this.getRow()[j];
            }
        }
        return multiplyMatrixByRow;
    }

    public int[][] squareMatrix() {
        int[][] squareMatrix = new int[5][5];
        for (int i = 0; i < this.getTable().length; ++i) {
            for (int j = 0; j < this.getTable().length; ++j) {
                squareMatrix[i][j] = this.getTable()[i][j] * this.getTable()[j][i];
            }
        }
        return squareMatrix;
    }

    public int scalarProduct() {
        int scalarProduct = 0;
        for (int i = 0; i < this.getRow().length; ++i) {
            scalarProduct += this.getRow()[i] * this.getRow()[i];
        }
        return Math.abs(scalarProduct);
    }

    public int[][] transposeMatrix() {
        int[][] transposeMatrix = new int[5][5];
        for (int i = 0; i < this.getTable().length; ++i) {
            for (int j = 0; j < this.getTable().length; ++j) {
                transposeMatrix[i][j] = this.getTable()[j][i];
            }
        }
        return transposeMatrix;
    }

    public int matrixTrace() {
        int matrixTrace = 0;
        for (int i = 0; i < this.getTable().length; ++i) {
            for (int j = 0; j < this.getTable().length; ++j) {
                if (i != j) continue;
                matrixTrace += this.getTable()[i][j];
            }
        }
        return matrixTrace;
    }

    public String toString(int[] matrix) {
        String result = "";
        result = result + String.format("%nrow%n", new Object[0]);
        for (int i = 0; i < matrix.length; ++i) {
            result = i != matrix.length - 1 ? result + matrix[i] + ", " : result + matrix[i];
        }
        return result;
    }

    public String toString(int[][] matrix) {
        String result = "";
        result = result + String.format("%ntable%n", new Object[0]);
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix.length; ++j) {
                result = j != matrix.length - 1 ? result + matrix[i][j] + ", " : result + matrix[i][j];
                if (j != matrix.length - 1) continue;
                result = result + String.format("%n", new Object[0]);
            }
        }
        return result;
    }

    public String toString() {
        int i;
        String result = "";
        result = result + String.format("table%n", new Object[0]);
        for (i = 0; i < this.getTable().length; ++i) {
            for (int j = 0; j < this.getTable().length; ++j) {
                result = j != this.getTable().length - 1 ? result + this.getTable()[i][j] + ", " : result + this.getTable()[i][j];
                if (j != this.getTable().length - 1) continue;
                result = result + String.format("%n", new Object[0]);
            }
        }
        result = result + String.format("%nrow%n", new Object[0]);
        for (i = 0; i < this.getRow().length; ++i) {
            result = i != this.getRow().length - 1 ? result + this.getRow()[i] + ", " : result + this.getRow()[i];
        }
        return result;
    }

    public int[][] getTable() {
        return this.table;
    }

    public final void setTable(int[][] table) {
        this.table = table;
    }

    public int[] getRow() {
        return this.row;
    }

    public void setRow(int[] row) {
        this.row = row;
    }
}

